﻿var quotaSettings = {
    context: $(".v-quotaSettings"),
    isTrackingEnabledGlobal: false,
    initialize: function () {
        quotaSettings.toggleQuotaInPercent();
        a4.initializeInputs(quotaSettings.context);
        projectMenu.onAfterRefresh = function () {
            window.location = window.location;
        };
    },
    bindEvents: function () {
        this.context.on("change", "#GlobalQuota", function () {
            quotaSettings.toggleQuotaInPercent();
        });

        this.context.on("change", "#EnableTrackingByPeriod", function () {
            quotaSettings.toggleTrackingVisibility();
        });
    },
    toggleQuotaInPercent: function () {
        var toDisabled = $("#GlobalQuota").val() == 0;

        if (toDisabled)
            $("#QuotaInPercent", quotaSettings.context).prop("checked", !toDisabled);

        $("#QuotaInPercent", quotaSettings.context).attr("disabled", toDisabled);
    },
    toggleTrackingVisibility: function () {
        var visible = $("#EnableTrackingByPeriod").is(":checked");
        $(".v-trackingByPeriodSection", quotaSettings.context).toggleClass("hidden", !visible);
    }
}

$(document).ready(function () {
    if (quotaSettings.context.length > 0) {
        quotaSettings.initialize();
        quotaSettings.bindEvents();
    }
});